import inspect


class NebuloidExposeAPI():
    def __init__(self, manifest):
        self.manifest = manifest
        self.registry = {}

    def portal(self, func=None):
        # Case 1: used as @neb.api
        if func and inspect.isfunction(func):
            self.registry[func.__name__] = func
            return func

        # Case 2: used as @neb.api()
        def decorator(f):
            self.registry[f.__name__] = f
            return f
        return decorator
    def ready(self):
        self.manifest.func_registry = self.registry

    
    